/* 
 *  Data.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.List;
import javafx.util.Pair;

public abstract class Data {

    private boolean deleted = false;

    public Data() {
    }

    public abstract List<Pair<String, String>> getProperties();

    public abstract List<Pair<String, Boolean>> getCaps();

    public abstract String getId();

    public String propsAsStrings() {
        List<Pair<String, String>> props = getProperties();
        String combined = "";
        for (Pair<String, String> prop : props) {
            combined += prop.getKey() + ":" + prop.getValue() + ",";
        }
        return combined;
    }

    public String capsAsStrings() {
        List<Pair<String, Boolean>> caps = getCaps();
        String combined = "";
        for (Pair<String, Boolean> cap : caps) {
            combined += cap.getKey() + ":" + cap.getValue() + ",";
        }
        return combined;
    }

    @Override
    public String toString() {
        return propsAsStrings() + capsAsStrings();
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public abstract void update(Data newData);
}
